///////////////////////////////////////////////////////////////////////////////////
// GameStudio main script
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "F:\\Lee-orr\\3dgamestudio\\3d game studio\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames
// change this string to your own starting mission message.
string mission_str = "Fight your way through the level. Press [F1] for help";
string level_str = <Lev_1.WMB>; // give file names in angular brackets

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.pcx>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky
sky horizon_sky {
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter
	type = <horizon.pcx>;
	tilt = -10;
	flags = scene,overlay,visible;
	layer = 3;
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	sleep(1);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();

// display the initial message
	msg_show(mission_str,10);

// initialize lens flares when edition supports flares
ifdef CAPS_FLARE;
	lensflare_start();
endif;

// use the new 3rd person camera
	move_view_cap = 1;

// un-freeze the game
	freeze_mode = 0;

//	client_move();	// for a possible multiplayer game
// call further functions here...
}


/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/

var playerpos[3];//make a vector for building the pistol again
var weapon_1;//make a virible for the weapon
function load_lev_2()
{
	weapon_1 = weapon1;//checks if the weapon is occupied and holds answer in weapon_1
	msg_show("You Have Succseded The Level!!! Wait Until Level 2 Finishes Loading", 5);//shows a loadlevel messege
	wait(2);//wait for the meassege to show
	my = null;// now, we have the mesage showen and the gun will stay ours for the next level.
	level_load("Lev_2.wmb");//load the level(write second level filename insted of "lev_2" and DONT
	// Delete The .WMB .)
	wait(1);// now our level will load, we will wait 1 frame sycle for the level to load
	if (weapon_1 != 0)//checks if gun was occupied
	{
		playerpos[0] = -1382.00;//checks player position
		playerpos[1] = -1523.000;
		playerpos[2] = -221.000;
		ent_create("pistol.mdl",playerpos, gun);//creates our gun
		
}
gun_select();
}

action level2
{
	MY.EVENT = load_lev_2;
	
	_doorevent_init();
	if(MY._FORCE == 0) { MY._FORCE = 5; }
	if(MY._ENDPOS == 0) { MY._ENDPOS = 90; }
	
}

/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;